#!/usr/bin/env python

import socket
import struct
import time

def main():
	defaultGroup = "224.3.3.3"
	defaultPort = 31337
	defaultTTL = 1

	interfaceIPList = [i[4][0] for i in socket.getaddrinfo(socket.gethostname(), None, family=socket.AF_INET)]
	for index, ip in enumerate(interfaceIPList, start=1):
		print(f"{index}:  {ip}")

	interfaceIndex = -1
	while interfaceIndex not in range(1,len(interfaceIPList)+1):
		try:
			interfaceIndex = int(input("Select which interface IP to listen on: "))
		except ValueError:
			pass
		
	INTERFACE_IP = interfaceIPList[interfaceIndex-1]

	MCAST_GRP = input(f"Multicast Address to listen on [{defaultGroup}]: ")
	if MCAST_GRP.strip() == "":
		MCAST_GRP = defaultGroup

	MCAST_PORT = input(f"UDP Port to listen on [{defaultPort}]: ")
	if MCAST_PORT.strip() == "":
		MCAST_PORT = defaultPort
	else:
		MCAST_PORT=int(MCAST_PORT)

	TTL = input(f"IP TTL [{defaultTTL}]: ")
	if TTL.strip() == "":
		TTL = defaultTTL
	else:
		TTL=int(TTL)

	sock = socket.socket(socket.AF_INET, socket.SOCK_DGRAM, socket.IPPROTO_UDP)
	sock.setsockopt(socket.IPPROTO_IP, socket.IP_MULTICAST_TTL, TTL)
	sock.bind((INTERFACE_IP,MCAST_PORT))
	packetNum = 1
	while True:
		try:
			print(f"Sending packet {packetNum}")
			sock.sendto(packetNum.to_bytes(8,"big"), (MCAST_GRP, MCAST_PORT))
			packetNum += 1
			time.sleep(1)
		except KeyboardInterrupt:
			print("Exiting")
			raise SystemExit

if __name__ == '__main__':
	main()