import socket
import struct


defaultGroup = "224.3.3.3"
defaultPort = 31337

interfaceIPList = [i[4][0] for i in socket.getaddrinfo(socket.gethostname(), None, family=socket.AF_INET)]
for index, ip in enumerate(interfaceIPList, start=1):
	print(f"{index}:  {ip}")

interfaceIndex = -1
while interfaceIndex not in range(1,len(interfaceIPList)+1):
	try:
		interfaceIndex = int(input("Select which interface IP to listen on: "))
	except ValueError:
		pass
	
INTERFACE_IP = interfaceIPList[interfaceIndex-1]

MCAST_GRP = input(f"Multicast Address to listen on [{defaultGroup}]: ")
if MCAST_GRP.strip() == "":
	MCAST_GRP = defaultGroup

MCAST_PORT = input(f"UDP Port to listen on [{defaultPort}]: ")
if MCAST_PORT.strip() == "":
	MCAST_PORT = defaultPort
else:
	MCAST_PORT=int(MCAST_PORT)

sock = socket.socket(socket.AF_INET, socket.SOCK_DGRAM, socket.IPPROTO_UDP)
sock.setsockopt(socket.SOL_SOCKET, socket.SO_REUSEADDR, 1)

sock.bind(("", MCAST_PORT))
mreq = struct.pack("4s4s", socket.inet_aton(MCAST_GRP), socket.inet_aton(INTERFACE_IP))

sock.setsockopt(socket.IPPROTO_IP, socket.IP_ADD_MEMBERSHIP, mreq)

sock.settimeout(0.1)

print(f"Listening on {MCAST_GRP}:{MCAST_PORT}...")

while True:
	try:
		data = sock.recv(8)
		decodedData = int.from_bytes(data,"big")
		print(f"Received Packet {decodedData}")
	except KeyboardInterrupt:
		print("Exiting")
		raise SystemExit
	except socket.timeout:
		pass